/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

class VWConfigSystemFieldSelectionDialog
extends VWModalDialog
implements ActionListener {
    protected static final int STATUS_OK = 0;
    protected static final int STATUS_CANCEL = 1;
    private VWAddRemovePanel m_addRemovePanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private int m_nReturnStatus = 1;

    public VWConfigSystemFieldSelectionDialog(Frame parent, String[] availableFields, String[] selectedFields) {
        super(parent);
        try {
            this.setTitle(VWResource.SystemFieldSelection);
            Dimension dim = VWStringUtils.stringToDimension("495,335");
            if (dim == null) {
                dim = new Dimension(400, 300);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            JPanel subPanel = new JPanel(new BorderLayout());
            subPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            subPanel.add((Component)this.createMainPanel(availableFields, selectedFields), "Center");
            subPanel.add((Component)this.createButtonPanel(), "Last");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)subPanel, "Center");
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String[] getSelectedItems() {
        if (this.m_addRemovePanel != null) {
            return this.m_addRemovePanel.getSelectedStringItems();
        }
        return null;
    }

    public int getReturnStatus() {
        return this.m_nReturnStatus;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_okButton) {
            this.m_nReturnStatus = 0;
            this.setVisible(false);
        } else if (obj == this.m_cancelButton) {
            this.m_nReturnStatus = 1;
            this.setVisible(false);
        }
    }

    public boolean isModified() {
        return this.m_addRemovePanel.isModified();
    }

    public void releaseResources() {
        if (this.m_addRemovePanel != null) {
            this.m_addRemovePanel.removeReferences();
            this.m_addRemovePanel = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton.removeAll();
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        this.removeAll();
    }

    private JPanel createMainPanel(String[] availableFields, String[] selectedFields) {
        try {
            this.m_addRemovePanel = new VWAddRemovePanel(10);
            this.m_addRemovePanel.enableSorting(768);
            this.m_addRemovePanel.initializeLists(availableFields, selectedFields);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_addRemovePanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            this.m_okButton = new JButton(VWResource.OK);
            buttonPanel.add((Component)this.m_okButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, buttonPanel, VWResource.OK, VWResource.OK);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            buttonPanel.add((Component)this.m_cancelButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, buttonPanel, VWResource.Cancel, VWResource.Cancel);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.m_okButton);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return buttonPanel;
    }
}

